#define  NO_TDB_PARSE

#define __TABLEDB_C
#define __TABLEDB_TDB

/* --- INCLUDE FILES --------------------------------------------------------------------------------------*/
#include "Application.h"
#include "Controller.h"
#include <TDB_Includes.h>

/* --- DEFINES --------------------------------------------------------------------------------------------*/
#define EXTERN_INSERT_POINT
/* VARList */
extern uint1 Table0Rev_cu1;
extern uint1 Table1Rev_cu1;
extern uint1 Table2Rev_cu1;
extern uint1 LinkStatus_ru1;
extern uint1 g_u1KeyRev;
extern uint1 g_u1EriRev;
extern uint1 Table3Rev_cu1;
extern uint1 Table4Rev_cu1;
extern uint1 Table5Rev_cu1;
extern uint1 Table6Rev_cu1;
extern uint1 Table7Rev_cu1;
extern NonVolatile_T NonVolatileWork;
extern uint1 g_u1MotProgRev;
extern S_ModuleConfig g_ConfigCopyObj;
extern uint1 g_u1TPUMaskVers;
extern uint2 g_u2InterruptStackMaxBytesFree;
extern uint4 g_pIdleStackMinBytesFree;
extern uint4 g_pBgndStackMinBytesFree;
extern uint4 g_pFgndTimeStackMinBytesFree;
extern uint4 g_pu4FgndAngleStackMinBytesFree;
extern uint4 g_u4PeakHeapBytesUsed;
extern uint1 OSInternalErrorCnt_ru1;
extern uint1 g_pSWISRCurrQueueSize;
extern uint4 SystemFrequency_cu4;
extern uint2 g_pu2IdlePerfTimerValue;
extern uint2 g_pu2BgndPerfTimerValue;
extern uint2 g_pu2FgndTimePerfTimerValue;
extern uint2 g_pu2FgndAnglePerfValue;
extern uint2 g_pCPUTime_CAN;
extern uint2 g_pCPUTime_TPU;
extern uint2 g_pCPUTime_MIOS;
extern uint2 g_pCPUTime_Serial;
extern uint2 g_pCPUTime_AppISR;
extern uint2 g_pCPUTime_TimerISR;
extern uint2 CPUMargin;
extern uint2 HeapMargin;
extern uint2 FgndTimeStackMargin;
extern uint2 BgndStackMargin;
extern uint2 IdleStackMargin;
extern uint2 InterruptStackMargin;
extern int32_T BGND_BASE_PERIODIC_RunCnt;
extern BlockIO_Controller Controller_B;
extern Volatile_T VolatileWork;
extern Constant_T ConstantWork;
extern int32_T FGND_RTI_PERIODIC_RunCnt;
extern uint4 NonVolatileCRC;
extern int32_T ONE_SECOND_EVENT_RunCnt;

/* BITVARList */
extern uint4 CodeCoveredBits[];

/* ENUMVARList */
extern uint1 g_eProjectID;
extern uint4 g_u4ProductID;
extern uint1 g_eTPUMaskType;
extern E_OSStatus OSStatus;
extern E_OSInternalErrorType OSErrorDisplay;
extern S_SetDisplayInfo FWModulesSetDisplayInfo;
extern uint1 g_u1BgndTimeSchdLateFlags;
extern uint2 g_u1FgndAngSchdLateFlags;
extern uint2 g_u1BgndAngSchdLateFlags;
extern E_ApplicationMonitorEnable ApplicationMonitorEnable;
extern E_ApplicationStatus ApplicationStatus;
extern E_ApplicationInitStatus ApplicationInitStatus;
extern uint32_T ApplicationStopReason;
extern E_ApplicationInitStatus ApplicationPausePoint;
extern uint32_T ApplicationStopReasonBlock;
extern uint1 NonVolatileRestoreOnFirstStartup;
extern uint1 NonVolatileRestoreOnStartup;
extern uint1 NonVolatileStatus;
extern E_NativeFWError ain_create_AN4M;
extern E_NativeFWError ain_create_AN5M;
extern E_NativeFWError ain_create_ECUP;
extern E_NativeFWError ain_read_AN4M;
extern E_NativeFWError ain_read_AN5M;
extern E_NativeFWError ain_read_ECUP;
extern E_NativeFWError can_create_CAN_1;
extern E_NativeFWError can_tx_err_CAN_1_0;
extern E_NativeFWError din_create_AN1M;
extern E_NativeFWError din_create_AN2M;
extern E_NativeFWError din_create_AN6M;
extern E_NativeFWError din_read_AN1M;
extern E_NativeFWError din_read_AN2M;
extern E_NativeFWError din_read_AN6M;
extern E_NativeFWError dout_create_FUELP;
extern E_NativeFWError dout_create_INJ1D;
extern E_NativeFWError dout_create_INJ2D;
extern E_NativeFWError dout_create_INJ3D;
extern E_NativeFWError dout_create_MPRD;
extern E_NativeFWError dout_create_TACH;
extern E_NativeFWError protocol_register_CAN_1;
extern E_NativeFWError resource_allocation;

/* TEXTList */
extern uint1 SwIdTxt[];
extern uint1 CalIdTxt[];
extern uint1 SwRevisionTxt[];
extern uint1 CompilerVersion[];
extern uint1 MatlabVersionTxt[];
extern uint1 MotoHawkModelGUID[];
extern uint1 MotoHawkTokenGUID[];
extern uint1 MotoHawkVersionTxt[];
extern uint1 MotoHawkModelName[];
extern uint1 FriendlyName[];
extern uint1 PasswordTxt[];
extern uint1 ControlCoreSDKRelease[];

/* ARRAYList */
extern S_HardwareCompatibilityEntry ApplicationCompatibilityArr[];


/* --- CONSTANTS ------------------------------------------------------------------------------------------*/
#include <Pragma_Section_Start_rosdata_constants.h>

/*:::::::::::::::::::::::::::::::
:: Table0   Diagnostics and DDT :
:::::::::::::::::::::::::::::::*/
const S_EriRequestTable __SECTION_ROSDATA_CONSTANTS__ Table0[] =                      /* diagnostics and the DDT */
{
	      {&g_eProjectID                            ,RW4+RO3+RO2+RO1 ,ENUMVAR    ,    1,FLASH   ,UINT1   },                       /* 0.0 -  Must always be item 0 in this table */
      {&Table0Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                      /* 0.1 -  Must always be item 1 in this table */
      {&Table1Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                      /* 0.2                     */
      {&Table2Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                      /* 0.3                     */
      {&LinkStatus_ru1                          ,RO4+RO3+NA2+NA1 ,VAR        ,    1,RAM     ,UINT1   },                       /* 0.4                     */
      {&g_u1KeyRev                              ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                           /* 0.5                     */
      {&g_u1EriRev                              ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                           /* 0.6                     */
      {&Table3Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                      /* 0.7                     */
      {&Table4Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                      /* 0.8                     */
      {&Table5Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                      /* 0.9                     */
      {&Table6Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                      /* 0.10                    */
      {&Table7Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                      /* 0.11                    */
      {&SwIdTxt[0]                              ,RO4+RO3+RO2+RO1 ,TEXT       ,   13,CODE    ,UINT1   },                          /* 0.12                    */
      {&CalIdTxt[0]                             ,RW4+RW3+RW2+RW1 ,TEXT       ,   33,FLASH   ,UINT1   },                         /* 0.13                    */
      {&SwRevisionTxt[0]                        ,RO4+RO3+RO2+RO1 ,TEXT       ,   50,CODE    ,UINT1   },                    /* 0.14                    */
      {&Table7Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                      /* 0.15                    */
      {&CompilerVersion[0]                      ,RO4+RO3+RO2+RO1 ,TEXT       ,   80,CODE    ,UINT1   },                  /* 0.16                    */
      {&MatlabVersionTxt[0]                     ,RO4+RO3+RO2+RO1 ,TEXT       ,   80,CODE    ,UINT1   },                 /* 0.17                    */
      {&NonVolatileWork.MotoHawkModelSecondsInUse,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,UINT4   },        /* 0.18                    */
      {&MotoHawkModelGUID[0]                    ,RO4+RO3+RO2+RO1 ,TEXT       ,   80,CODE    ,UINT1   },                /* 0.19                    */
      {&MotoHawkTokenGUID[0]                    ,RO4+RO3+RO2+RO1 ,TEXT       ,   80,CODE    ,UINT1   },                /* 0.20                    */
      {&MotoHawkTokenGUID[0]                    ,RO4+RO3+RO2+RO1 ,TEXT       ,   80,CODE    ,UINT1   },                /* 0.21                    */
      {&MotoHawkVersionTxt[0]                   ,RO4+RO3+RO2+RO1 ,TEXT       ,   50,CODE    ,UINT1   },               /* 0.22                    */
      {&MotoHawkModelName[0]                    ,RO4+RO3+RO2+RO1 ,TEXT       ,   80,CODE    ,UINT1   },                /* 0.23                    */
      {&FriendlyName[0]                         ,RW4+RW3+RO2+RO1 ,TEXT       ,   33,FLASH   ,UINT1   },                     /* 0.24                    */
      {&g_u4ProductID                           ,RW4+RO3+RO2+RO1 ,ENUMVAR    ,    1,FLASH   ,UINT4   },                        /* 0.25                    */
      {&g_u1MotProgRev                          ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                       /* 0.26                    */
      {&g_ConfigCopyObj.BootVerMaj              ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                       /* 0.27                    */
      {&g_ConfigCopyObj.BootVerMin              ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                       /* 0.28                    */
      {&g_ConfigCopyObj.EcuHwMaj                ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                         /* 0.29                    */
      {&g_ConfigCopyObj.EcuHwMin                ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },                         /* 0.30                    */
      {&ApplicationCompatibilityArr[0]          ,RO4+RO3+RO2+RO1 ,ARRAY      ,   50,CODE    ,UINT2   },      /* 0.31                    */
      {&g_ConfigCopyObj.psSerialNumber          ,RO4+RO3+RO2+RO1 ,TEXT_PTR   ,   10,CODE    ,UINT1   },
      {&g_ConfigCopyObj.psModelNumber           ,RO4+RO3+RO2+RO1 ,TEXT_PTR   ,   20,CODE    ,UINT1   },

      {&PasswordTxt[0]                          ,RW4+RW3+RO2+RO1 ,TEXT       ,   33,FLASH   ,UINT1   },
      {&g_ConfigCopyObj.Capability              ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,CODE    ,UINT1   },
      {&g_ConfigCopyObj.psModelNumber           ,RO4+RO3+RO2+RO1 ,TEXT_PTR   ,   20,CODE    ,UINT1   },
      {&g_ConfigCopyObj.u1ConfigVerMaj          ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },
      {&g_ConfigCopyObj.u1ConfigVerMin          ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },
      {&g_ConfigCopyObj.psPartNumber            ,RO4+RO3+RO2+RO1 ,TEXT_PTR   ,   40,CODE    ,UINT1   },
      {&ControlCoreSDKRelease[0]                ,RO4+RO3+RO2+RO1 ,TEXT       ,   50,CODE    ,UINT1   },
      {&Table7Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },
      {&Table7Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },
      {&Table7Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },
      {&g_u1TPUMaskVers                         ,RO4+RO3+NA2+NA1 ,VAR        ,    1,RAM     ,UINT1   },
      {&g_eTPUMaskType                          ,RO4+RO3+NA2+NA1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
      {&g_u2InterruptStackMaxBytesFree          ,RO4+RO3+NA2+NA1 ,VAR        ,    1,RAM     ,UINT2   },
      {&g_pIdleStackMinBytesFree                ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT4   },
      {&g_pBgndStackMinBytesFree                ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT4   },
      {&g_pFgndTimeStackMinBytesFree            ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT4   },
      {&g_pu4FgndAngleStackMinBytesFree         ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT4   },
      {&g_u4PeakHeapBytesUsed                   ,RO4+RO3+NA2+NA1 ,VAR        ,    1,RAM     ,UINT4   },
      {&OSStatus                                ,RO4+RO3+NA2+NA1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
      {&OSInternalErrorCnt_ru1                  ,RO4+RO3+NA2+NA1 ,VAR        ,    1,RAM     ,UINT1   },
      {&OSErrorDisplay                          ,RO4+RO3+NA2+NA1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
      {&FWModulesSetDisplayInfo.DisplayVar      ,RO4+RO3+NA2+NA1 ,ENUMVAR    ,    1,RAM     ,UINT2   },
      {&g_pSWISRCurrQueueSize                   ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT1   },
      {&SystemFrequency_cu4                     ,RO4+RO3+NA2+NA1 ,VAR        ,    1,CODE    ,UINT4   },
      {&g_u1BgndTimeSchdLateFlags               ,RO4+RO3+NA2+NA1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
      {&g_u1FgndAngSchdLateFlags                ,RO4+RO3+NA2+NA1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
      {&g_u1BgndAngSchdLateFlags                ,RO4+RO3+NA2+NA1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
      {&g_pu2IdlePerfTimerValue                 ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT2   },
      {&g_pu2BgndPerfTimerValue                 ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT2   },
      {&g_pu2FgndTimePerfTimerValue             ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT2   },
      {&g_pu2FgndAnglePerfValue                 ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT2   },
      {&g_pCPUTime_CAN                          ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT2   },
      {&g_pCPUTime_TPU                          ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT2   },
      {&g_pCPUTime_MIOS                         ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT2   },
      {&g_pCPUTime_Serial                       ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT2   },
      {&g_pCPUTime_AppISR                       ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT2   },
      {&g_pCPUTime_TimerISR                     ,RO4+RO3+NA2+NA1 ,VAR_PTR    ,    1,RAM     ,UINT2   },
      {&ApplicationMonitorEnable                ,RW4+RW3+RO2+RO1 ,ENUMVAR    ,    1,FLASH   ,UINT1   },     
      {&ApplicationStatus                       ,RW4+RW3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },            
      {&ApplicationInitStatus                   ,RO4+RO3+NA2+NA1 ,ENUMVAR    ,    1,RAM     ,UINT1   },        
      {&ApplicationStopReason                   ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT4   },        
      {&ApplicationPausePoint                   ,RW4+RW3+RO2+RO1 ,ENUMVAR    ,    1,FLASH   ,UINT1   },        
      {&CPUMargin                               ,RW4+RW3+RO2+RO1 ,VAR        ,    1,FLASH   ,UINT2   },                    
      {&HeapMargin                              ,RW4+RW3+RO2+RO1 ,VAR        ,    1,FLASH   ,UINT2   },                   
      {&FgndTimeStackMargin                     ,RW4+RW3+RO2+RO1 ,VAR        ,    1,FLASH   ,UINT2   },          
      {&BgndStackMargin                         ,RW4+RW3+RO2+RO1 ,VAR        ,    1,FLASH   ,UINT2   },              
      {&IdleStackMargin                         ,RW4+RW3+RO2+RO1 ,VAR        ,    1,FLASH   ,UINT2   },              
      {&InterruptStackMargin                    ,RW4+RW3+RO2+RO1 ,VAR        ,    1,FLASH   ,UINT2   },         
};
#define TABLE0_LENGTH 82



/*:::::::::
:: Table1 :
::::::::::*/
const S_EriRequestTable __SECTION_ROSDATA_CONSTANTS__ Table1[] =
{
	  {&ApplicationStopReasonBlock              ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT4   },
	  {&BGND_BASE_PERIODIC_RunCnt               ,RW4+RW3+NA2+NA1 ,VAR        ,    1,RAM     ,SINT4   },
	  {&Controller_B.s19_Battery_Connect_Command,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_ReadCANMessage_o3       ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_ReadCANMessage4         ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_ReadCANMessage_o1       ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_ReadCANMessage_o2       ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s11_Foundation_Brake_Request,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_CAN_1_std_handled_count ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,UINT4   },
	  {&VolatileWork.mh_CAN_1_std_last_unhandled_id,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,UINT4   },
	  {&VolatileWork.mh_CAN_1_std_receive_count ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,UINT4   },
	  {&Controller_B.s12_Charge_State           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&NonVolatileWork.mh_CityID_CAN_1         ,RW4+NA3+NA2+NA1 ,VAR        ,    1,FLASH   ,UINT1   },
	/*{CodeCover000000,CodeCoverParent000:0                      ,BIT                             },*/
	/*{CodeCover000001,CodeCoverParent000:1                      ,BIT                             },*/
	/*{CodeCover000002,CodeCoverParent000:2                      ,BIT                             },*/
	/*{CodeCover000003,CodeCoverParent000:3                      ,BIT                             },*/
	/*{CodeCover000004,CodeCoverParent000:4                      ,BIT                             },*/
	/*{CodeCover000005,CodeCoverParent000:5                      ,BIT                             },*/
	/*{CodeCover000006,CodeCoverParent000:6                      ,BIT                             },*/
	/*{CodeCover000007,CodeCoverParent000:7                      ,BIT                             },*/
	/*{CodeCover000008,CodeCoverParent000:8                      ,BIT                             },*/
	/*{CodeCover000009,CodeCoverParent000:9                      ,BIT                             },*/
	/*{CodeCover000010,CodeCoverParent000:10                     ,BIT                             },*/
	/*{CodeCover000011,CodeCoverParent000:11                     ,BIT                             },*/
	/*{CodeCover000012,CodeCoverParent000:12                     ,BIT                             },*/
	/*{CodeCover000013,CodeCoverParent000:13                     ,BIT                             },*/
	/*{CodeCover000014,CodeCoverParent000:14                     ,BIT                             },*/
	/*{CodeCover000015,CodeCoverParent000:15                     ,BIT                             },*/
	/*{CodeCover000016,CodeCoverParent000:16                     ,BIT                             },*/
	/*{CodeCover000017,CodeCoverParent000:17                     ,BIT                             },*/
	/*{CodeCover000018,CodeCoverParent000:18                     ,BIT                             },*/
	/*{CodeCover000019,CodeCoverParent000:19                     ,BIT                             },*/
	/*{CodeCover000020,CodeCoverParent000:20                     ,BIT                             },*/
	/*{CodeCover000021,CodeCoverParent000:21                     ,BIT                             },*/
	/*{CodeCover000022,CodeCoverParent000:22                     ,BIT                             },*/
	/*{CodeCover000023,CodeCoverParent000:23                     ,BIT                             },*/
	/*{CodeCover000024,CodeCoverParent000:24                     ,BIT                             },*/
	  {&CodeCoveredBits[0]                      ,RO4+RO3+RO2+RO1 ,BITVAR     ,    1,RAM     ,UINT4   },
	  {&ConstantWork.mh_Current_Feedback_I_Gain ,RW4+RW3+RW2+RW1 ,VAR        ,    1,FLASH   ,REAL4   },
	  {&ConstantWork.mh_Current_Feedback_P_Gain ,RW4+RW3+RW2+RW1 ,VAR        ,    1,FLASH   ,REAL4   },
	  {&Controller_B.s1_Sum                     ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_Sum1                    ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&ConstantWork.mh_ECUP_Threshold          ,RW4+RW3+RW2+RW1 ,VAR        ,    1,FLASH   ,UINT2   },
	  {&Controller_B.s1_ReadCANMessage2_o2      ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s12_Engine_On              ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s18_Yk                     ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_ReadCANMessage2_o3      ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s19_Error                  ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_Error_LED_new           ,RW4+RW3+RW2+RW1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_Error_LED_ovr           ,RW4+RW3+RW2+RW1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&FGND_RTI_PERIODIC_RunCnt                ,RW4+RW3+NA2+NA1 ,VAR        ,    1,RAM     ,SINT4   },
	  {&Controller_B.s13_DiscreteTransferFcn    ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s19_Forward_LED            ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_Forward_LED_new         ,RW4+RW3+RW2+RW1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_Forward_LED_ovr         ,RW4+RW3+RW2+RW1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&Controller_B.s1_DataTypeConversion9     ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_ReadCANMessage5         ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s19_Gen_Enable             ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_ReadCANMessage1_o2      ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s3_Product                 ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_ReadCANMessage1_o3      ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_ReadCANMessage1_o1      ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_MPRD                    ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&VolatileWork.mh_MPRD_KeepAlive          ,RW4+RW3+RW2+RW1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&VolatileWork.mh_MPRD_new                ,RW4+RW3+RW2+RW1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&VolatileWork.mh_MPRD_ovr                ,RW4+RW3+RW2+RW1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&Controller_B.s1_ReadCANMessage2_o1      ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_ReadCANMessage3_o2      ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s19_Motor_Enable           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_ReadCANMessage6         ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_ReadCANMessage3_o3      ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s11_Product4               ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s1_ReadCANMessage3_o1      ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&NonVolatileCRC                          ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,UINT4   },
	  {&NonVolatileWork.NonVolatileFormatID     ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,UINT4   },
	  {&NonVolatileRestoreOnFirstStartup        ,RW4+RW3+RW2+RW1 ,ENUMVAR    ,    1,FLASH   ,UINT1   },
	  {&NonVolatileRestoreOnStartup             ,RW4+RW3+RW2+RW1 ,ENUMVAR    ,    1,FLASH   ,UINT1   },
	  {&NonVolatileStatus                       ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&ONE_SECOND_EVENT_RunCnt                 ,RW4+RW3+NA2+NA1 ,VAR        ,    1,RAM     ,SINT4   },
	  {&Controller_B.s19_Park_LED               ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_Park_LED_new            ,RW4+RW3+RW2+RW1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_Park_LED_ovr            ,RW4+RW3+RW2+RW1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&Controller_B.s1_DataTypeConversion8     ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_ProcessorReboot         ,RW4+RW3+RW2+RW1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&VolatileWork.mh_RestoreNVFactoryDefaults,RW4+RW3+RW2+RW1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&Controller_B.s19_Reverse_LED            ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_Reverse_LED_new         ,RW4+RW3+RW2+RW1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_Reverse_LED_ovr         ,RW4+RW3+RW2+RW1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&Controller_B.s1_DataTypeConversion10    ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&ConstantWork.mh_Speed_Feedback_I_Gain   ,RW4+RW3+RW2+RW1 ,VAR        ,    1,FLASH   ,REAL4   },
	  {&ConstantWork.mh_Speed_Feedback_P_Gain   ,RW4+RW3+RW2+RW1 ,VAR        ,    1,FLASH   ,REAL4   },
	  {&Controller_B.s19_State                  ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_StoreNV                 ,RW4+RW3+RW2+RW1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&VolatileWork.mh_Vehicle_Key             ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&Controller_B.s19_Vehicle_Ready          ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_Vehicle_Ready_LED_new   ,RW4+RW3+RW2+RW1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&VolatileWork.mh_Vehicle_Ready_LED_ovr   ,RW4+RW3+RW2+RW1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&Controller_B.s1_secondsperhour          ,RO4+RO3+RO2+RO1 ,VAR        ,    1,RAM     ,REAL4   },
	  {&ain_create_AN4M                         ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&ain_create_AN5M                         ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&ain_create_ECUP                         ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&ain_read_AN4M                           ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&ain_read_AN5M                           ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&ain_read_ECUP                           ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&can_create_CAN_1                        ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&can_tx_err_CAN_1_0                      ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&din_create_AN1M                         ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&din_create_AN2M                         ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&din_create_AN6M                         ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&din_read_AN1M                           ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&din_read_AN2M                           ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&din_read_AN6M                           ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&dout_create_FUELP                       ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&dout_create_INJ1D                       ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&dout_create_INJ2D                       ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&dout_create_INJ3D                       ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&dout_create_MPRD                        ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&dout_create_TACH                        ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&protocol_register_CAN_1                 ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
	  {&resource_allocation                     ,RO4+RO3+RO2+RO1 ,ENUMVAR    ,    1,RAM     ,UINT1   },
};
#define TABLE1_LENGTH 96

/*:::::::::
:: Table2 :
::::::::::*/
const S_EriRequestTable __SECTION_ROSDATA_CONSTANTS__ Table2[] =
{
      {&Table2Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },
};
#define TABLE2_LENGTH 1

/*:::::::::
:: Table3 :
::::::::::*/
const S_EriRequestTable __SECTION_ROSDATA_CONSTANTS__ Table3[] =
{
      {&Table3Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },
};
#define TABLE3_LENGTH 1

/*:::::::::
:: Table4 :
::::::::::*/
const S_EriRequestTable __SECTION_ROSDATA_CONSTANTS__ Table4[] =
{
      {&Table4Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },
};
#define TABLE4_LENGTH 1

/*:::::::::
:: Table5 :
::::::::::*/
const S_EriRequestTable __SECTION_ROSDATA_CONSTANTS__ Table5[] =
{
      {&Table5Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },
};
#define TABLE5_LENGTH 1

/*:::::::::
:: Table6 :
::::::::::*/
const S_EriRequestTable __SECTION_ROSDATA_CONSTANTS__ Table6[] =
{
      {&Table6Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },
};
#define TABLE6_LENGTH 1

/*:::::::::
:: Table7 :
::::::::::*/
const S_EriRequestTable __SECTION_ROSDATA_CONSTANTS__ Table7[] =
{
      {&Table7Rev_cu1                           ,RO4+RO3+RO2+RO1 ,VAR        ,    1,CODE    ,UINT1   },
};
#define TABLE7_LENGTH 1


/* List of table addresses*/
const S_EriReqTblList __SECTION_ROSDATA_CONSTANTS__ EriRequestTableList[8] = 
{
        { Table0, TABLE0_LENGTH },
        { Table1, TABLE1_LENGTH },
        { Table2, TABLE2_LENGTH },
        { Table3, TABLE3_LENGTH },
        { Table4, TABLE4_LENGTH },
        { Table5, TABLE5_LENGTH },
        { Table6, TABLE6_LENGTH },
        { Table7, TABLE7_LENGTH },
};   


#include <Pragma_Section_End_rosdata.h>

/* --- CALIBRATION ----------------------------------------------------------------------------------------*/
#include <Pragma_Section_Start_rodata_cals.h>

#include <Pragma_Section_End_rodata.h>

/* --- RAM VARIABLES --------------------------------------------------------------------------------------*/
#include <Pragma_Section_Start_sbss_zerovars.h>

#include <Pragma_Section_End_sbss.h>

/* --- CODE SPACE -----------------------------------------------------------------------------------------*/
#include <Pragma_Section_Start_text_code.h>

/* --- INLINE FUNCTIONS -----------------------------------------------------------------------------------*/

/* --- LOCAL FUNCTIONS ------------------------------------------------------------------------------------*/

 S_EriReqTblList const* GetERIRequestTablePtr(uint1 table)
{
    return (&EriRequestTableList[table]);
}

